2


export class DayPriceListWidget {

	tpl = `
		<div class="page-header">
			<div class="toolbox">
				<a href="javascript:void(0);" [onclick]="widget.goBack_Click" class="fa fa-chevron-circle-left"></a>
				<a href="javascript:void(0);" [onclick]="widget.add_Click" class="fa fa-plus"></a>
			</div>
			
			<h1>{{_('Day prices')}}</h1>
		</div>
		
		
		

		<div ez-if="dayprices == null">
			Loading...
		</div>
		<div ez-if="dayprices != null">
			<table class="table">
				<thead>
					<tr>
						<th>Naam</th>
					</tr>
				</thead>
				<tbody>
					<tr ez-forme="dayprices" ez-item="dp" [onclick]="widget.editDayprice_Click" class="pointer" dayprice-id="{{dp.daypriceId}}">
						<td>{{dp.name}}</td>
					</tr>
				</tbody>
					<tr ez-if="dayprices.length == 0">
						<td colspan="100%" class="no-results">Geen resultaten gevonden</td>
					</tr>
			</table>
			
			<ez-pager></ez-pager>
		</div>
	`;
	
	
	container = null;
	dayprices = null;
	pageNo = 0;
	
	
	init(e) {
		
		this.container = e;
		
		this.render();
		
		this.loadDayprices();
	}
	

	loadDayprices() {
		postUrl( '/service/sales/rental/dayprice.do', {
			a: 'search',
			pageNo: this.pageNo
		} ).then( async function(e) {
			let json = await e.json();
			if (json.error) {
				return showErrorWidget( json );
			}
			
			this.dayprices = json.dayprices;
			this.response = json;
			
			this.render();
			
		}.bind(this));
	}
	

	selectPage(pageNo) {
		this.pageNo = pageNo;
		this.loadDayprices();
	}
	
	render() {
		let tpl = new EzTemplate( this.container );
		tpl.setObject('widget', this);
		tpl.setVar('dayprices', this.dayprices);
		tpl.loadHtml( this.tpl );
		tpl.render();
		
	}
	
	
	editDayprice_Click(evt, tr) {
		let id = tr.getAttribute('dayprice-id');
		
		gotoRoute('/masterdata/sales/dayprice/edit/?id='+id);
	}
	
	add_Click() {
		gotoRoute( '/masterdata/sales/dayprice/edit/' );
	}
	
	
	goBack_Click() {
		gotoRoute( '/masterdata/' );
	}
	
	
}



